# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sddefinition import *
from .sdarray import *
from .sdproperty import *
from .sdvalue import *
from .sdconnection import *
from .sdresource import *
from .sdgraph import *
from .sdtype import *
from .sdapiobject import *
from .sdbasetypes import *
from .sdproperty import *
from .sdproperty import *
from .sdresource import *
from .sdtype import *
from .sdapiobject import *
from .apiexception import APIException

class SDNode(SDAPIObject):
    """
    Base class of all nodes (as elements of graphs)
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDNode
        """
        super(SDNode, self).__init__(APIContext, handle, *args, **kwargs)

    def getDefinition(self) -> Optional[SDDefinition]:
        """
        Get the definition of the node

        """
        outSDDefinition = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getDefinition(self.mHandle, ctypes.byref(outSDDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDDefinition, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDDefinition.value, ownHandle=True)

    def getPosition(self) -> float2:
        """
        Get the node position within its graph

        """
        outPosition = float2()
        _res = self.mAPIContext.SDNode_getPosition(self.mHandle, ctypes.byref(outPosition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPosition

    def setPosition(self, position : float2) -> None:
        """
        Set the node position within its graph. Note that the X+ is oriented to the right and the Y+ axis is oriented to the bottom.

        :param position: The new node position in the graph
        """
        _res = self.mAPIContext.SDNode_setPosition(self.mHandle, ctypes.byref(position))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getProperties(self, sdPropertyCategory : SDPropertyCategory) -> SDArray[SDProperty]:
        """
        Get all node properties for the specified SDPropertyCategory

        :param sdPropertyCategory: The category of the property
        """
        outSDPropertyArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getProperties(self.mHandle, sdPropertyCategory.value, ctypes.byref(outSDPropertyArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPropertyArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPropertyArray.value, ownHandle=True)

    def getPropertyFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDProperty]:
        """
        Get the property that matches the specified identifier in the specified category

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getPropertyFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def getPropertyValue(self, sdProperty : SDProperty) -> Optional[SDValue]:
        """
        Get the value of the specified node property

        :param sdProperty: The property we want to retrieve the value from
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getPropertyValue(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyValue(self, sdProperty : SDProperty, sdValue : SDValue) -> None:
        """
        Set the value of the specified node property. Note that this operation is not allowed for sdProperty that  if the SDProperty.isFunctionOnly() method returns true

        :param sdProperty: The property we want to retrieve the value from
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDNode_setPropertyValue(self.mHandle, sdProperty.mHandle, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setInputPropertyValueFromId(self, sdInputPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the specified node input property retrieved by his identifier

        :param sdInputPropertyId: The identifier of the input property we want to set
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDNode_setInputPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdInputPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setAnnotationPropertyValueFromId(self, sdAnnotationPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the specified node annotation property retrieved by his identifier

        :param sdAnnotationPropertyId: The identifier of the annotation property we want to set
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDNode_setAnnotationPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdAnnotationPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyValueFromId(self, sdPropertyId : str, sdPropertyCategory : SDPropertyCategory) -> Optional[SDValue]:
        """
        Get the value of the property that matches the specified identifier in the specified category

        :param sdPropertyId: The identifier of the property we want to retrieve
        :param sdPropertyCategory: The category of the property
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdPropertyCategory.value, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def getInputPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the input property that matches the specified identifier

        :param sdPropertyId: The identifier of the input property we want to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getInputPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def getAnnotationPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the annotation property that matches the specified identifier

        :param sdPropertyId: The identifier of the annotation property we want to retrieve
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getAnnotationPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def newPropertyConnection(self, sdOutputProperty : SDProperty, sdInputPropertyNode : SDNode, sdInputProperty : SDProperty) -> Optional[SDConnection]:
        """
        Create a new connection between an output property of the current node to an input property of another node

        :param sdOutputProperty: The output property from where to start a new connection
        :param sdInputPropertyNode: The other node
        :param sdInputProperty: The input property of the other node that will be connected
        """
        outSDConnection = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_newPropertyConnection(self.mHandle, sdOutputProperty.mHandle, sdInputPropertyNode.mHandle, sdInputProperty.mHandle, ctypes.byref(outSDConnection))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDConnection, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDConnection.value, ownHandle=True)

    def newPropertyConnectionFromId(self, sdOutputPropertyId : str, sdInputPropertyNode : SDNode, sdInputPropertyId : str) -> SDConnection:
        """
        Create a new connection between an output property of the current node to an input property of a target node based on the properties identifiers

        :param sdOutputPropertyId: The output property identifier from where to start a new connection
        :param sdInputPropertyNode: The other node
        :param sdInputPropertyId: The input property identifier of the other node that will be connected
        """
        outSDConnection = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_newPropertyConnectionFromId(self.mHandle, ctypes.create_string_buffer(sdOutputPropertyId.encode('utf-8')), sdInputPropertyNode.mHandle, ctypes.create_string_buffer(sdInputPropertyId.encode('utf-8')), ctypes.byref(outSDConnection))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDConnection, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDConnection.value, ownHandle=True)

    def deletePropertyConnections(self, sdProperty : SDProperty) -> None:
        """
        Delete all connections of the specified property

        :param sdProperty: The SDProperty whose connections will be disconnected
        """
        _res = self.mAPIContext.SDNode_deletePropertyConnections(self.mHandle, sdProperty.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyConnections(self, sdProperty : SDProperty) -> SDArray[SDConnection]:
        """
        Get all connections of the specified property

        :param sdProperty: The Property we want to retrieve the connections from
        """
        outSDConnectionArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getPropertyConnections(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDConnectionArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDConnectionArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDConnectionArray.value, ownHandle=True)

    def getReferencedResource(self) -> Optional[SDResource]:
        """
        Get the SDResource referenced by the current node, if any

        """
        outSDResource = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getReferencedResource(self.mHandle, ctypes.byref(outSDResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDResource, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDResource.value, ownHandle=True)

    def getPropertyGraph(self, sdProperty : SDProperty) -> Optional[SDGraph]:
        """
        Get the graph that controls the specified property

        :param sdProperty: The property we want to retrieve the value from
        """
        outSDGraph = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_getPropertyGraph(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDGraph))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraph, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraph.value, ownHandle=True)

    def newPropertyGraph(self, sdProperty : SDProperty, sdGraphTypeId : str) -> Optional[SDGraph]:
        """
        Reset the graph that controls the specified property

        :param sdProperty: The property we want to retrieve the value from
        :param sdGraphTypeId: The type name of the graph to create on the property. Supported graph name depends on the node and property
        """
        outSDGraph = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_newPropertyGraph(self.mHandle, sdProperty.mHandle, ctypes.create_string_buffer(sdGraphTypeId.encode('utf-8')), ctypes.byref(outSDGraph))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraph, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraph.value, ownHandle=True)

    def deletePropertyGraph(self, sdProperty : SDProperty) -> None:
        """
        Delete the graph that controls the specified property, and restore the previous constant value

        :param sdProperty: The property from which we want to remove the graph
        """
        _res = self.mAPIContext.SDNode_deletePropertyGraph(self.mHandle, sdProperty.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getIdentifier(self) -> str:
        """
        Get the node identifier in the context of its graph

        """
        outIdentifier = ctypes.c_char_p()
        _res = self.mAPIContext.SDNode_getIdentifier(self.mHandle, ctypes.byref(outIdentifier))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outIdentifier.value.decode('utf-8') # type: ignore

    def newProperty(self, sdPropertyIdentifier : str, sdPropertyType : SDType, sdPropertyCategory : SDPropertyCategory) -> Optional[SDProperty]:
        """
        Create a new property

        :param sdPropertyIdentifier: The identifier of the new property
        :param sdPropertyType: The type of the new property
        :param sdPropertyCategory: The category of the property
        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDNode_newProperty(self.mHandle, ctypes.create_string_buffer(sdPropertyIdentifier.encode('utf-8')), sdPropertyType.mHandle, sdPropertyCategory.value, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def deleteProperty(self, sdProperty : SDProperty) -> None:
        """
        Delete the specified property

        :param sdProperty: The property to remove
        """
        _res = self.mAPIContext.SDNode_deleteProperty(self.mHandle, sdProperty.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

